%This program is used to eastimate the mean function at x0 by using
%the estimator (3) in our paper.
%x0 is a scalar
%x, y are the raw data
%h is the bandwidth
%r is the covariance of each subject among different time points

function mestimate=Estimate_1_i(x0,x,y,h,r)
p=1;
n=length(x(1,:));
J=length(x(:,1));
X=[x-x0];
w=Weight_1_i(x0,x,h,r);%it is the W in our paper
temp1=zeros(p+1,p+1);
temp2=zeros(p+1,1);
for i=1:n
temp1=temp1+[ones(J,1),X(:,i)]'*w(:,:,i)*[ones(J,1),X(:,i)];
temp2=temp2+[ones(J,1),X(:,i)]'*w(:,:,i)*y(:,i);
end
betaest=pinv(temp1)*temp2;
mestimate=[1;0]'*betaest;
